///////////////////////////////////////////////////////////////////////////////
//
//    (C) Copyright 1995 - 2005 OSR Open Systems Resources, Inc.
//    (C) Copyright 2000 MicroSoft, Inc.
//    All Rights Reserved
//
//    This sofware is supplied for instructional purposes only.
//
//    OSR Open Systems Resources, Inc. (OSR) expressly disclaims any warranty
//    for this software.  THIS SOFTWARE IS PROVIDED  "AS IS" WITHOUT WARRANTY
//    OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT LIMITATION,
//    THE IMPLIED WARRANTIES OF MECHANTABILITY OR FITNESS FOR A PARTICULAR
//    PURPOSE.  THE ENTIRE RISK ARISING FROM THE USE OF THIS SOFTWARE REMAINS
//    WITH YOU.  OSR's entire liability and your exclusive remedy shall not
//    exceed the price paid for this material.  In no event shall OSR or its
//    suppliers be liable for any damages whatsoever (including, without
//    limitation, damages for loss of business profit, business interruption,
//    loss of business information, or any other pecuniary loss) arising out
//    of the use or inability to use this software, even if OSR has been
//    advised of the possibility of such damages.  Because some states/
//    jurisdictions do not allow the exclusion or limitation of liability for
//    consequential or incidental damages, the above limitation may not apply
//    to you.
//
//    OSR Open Systems Resources, Inc.
//    105 Route 101A Suite 19
//    Amherst, NH 03031  (603) 595-6500 FAX: (603) 595-6503
//    email bugs to: bugs@osr.com
//
//
//    MODULE:
//
//        proppage.cpp -- Redirect driver Property Page dll
//
//    ABSTRACT:
//
//      This DLL is merely a resource DLL.
//
//    AUTHOR(S):
//
//        OSR Open Systems Resources, Inc.
// 
//    REVISION:   
//
///////////////////////////////////////////////////////////////////////////////

#include <windows.h>
#include <setupapi.h>
#include "proppage.h"
#include "prvprop.h"
#include "resource.h"
#include <winioctl.h>

#if DBG
#define RedirectOutputDebugString(a) OutputDebugString(a)
#else
#define RedirectOutputDebugString(a)
#endif

HINSTANCE   ghInstance = NULL;


///////////////////////////////////////////////////////////////////////////////
//
//  DllMain
//
//      This function is called when processes or threads attach or detach
//      from the DLL.
//
//  INPUTS:
//
//      hModule - handle of the module attaching.
//      ul_reason_for_call - why DLL is being called.
//      lpReserved - reserved.
//
//  OUTPUTS:
//
//      None.
//
//  RETURNS:
//
//      TRUE, if operation successful.
//
//  NOTES:
//
//
///////////////////////////////////////////////////////////////////////////////
BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call) {

		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
    }

    ghInstance = (HINSTANCE) hModule;

    RedirectOutputDebugString("DllMain Entered\n");

    return TRUE;
}


///////////////////////////////////////////////////////////////////////////////
//
//  GetDeviceInterfaceDetail
//
//      This function gets called by the property page provider (in this module) to
//      get the device interface details. The device interface detail contains a
//      path to the device driver that can be used to open the device driver.
//      When we parse the driver we look for the interface the Redirect WDM driver
//      exposes.
//
//  INPUTS:
//
//      pPropPageRequest           - points to SP_PROPSHEETPAGE_REQUEST
//      pDeviceInterfaceDetailData - device interface details returned.
//
//  OUTPUTS:
//
//      None.
//
//  RETURNS:
//
//      TRUE, if operation successful, FALSE otherwise.
//
//  NOTES:
//
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//
//  REDIRECTPropPageProvider
//
//      This function gets called by the device manager when it asks for additional
//      property sheet pages. The parameter fAddFunc is the function that we call to
//      add the sheet page to the dialog.
//      This routine gets called because the registry entry "EnumPropPage32" tells
//      the device manager that there is a dll with a exported function that will add
//      a property sheet page.
//
//      Because we want to fail this function (not create the sheet) if the driver
//      doesn't support the private property, we have to do all the work here, that
//      means we open the device and get all the information, then we close the
//      device and return.
//
//  INPUTS:
//
//      pPropPageRequest - points to SP_PROPSHEETPAGE_REQUEST
//      fAddFunc         - function ptr to call to add sheet.
//      lparam           - add sheet functions private data handle.
//
//  OUTPUTS:
//
//      None.
//
//  RETURNS:
//
//      BOOL: FALSE if pages could not be added, TRUE on success.
//
//  NOTES:
//
//
///////////////////////////////////////////////////////////////////////////////
BOOL APIENTRY REDIRECTPropPageProvider(PSP_PROPSHEETPAGE_REQUEST   pPropPageRequest,
	                                  LPFNADDPROPSHEETPAGE	    fAddFunc,
                                      LPARAM					lParam)
{
	return TRUE;
}

