
//
// Test.C
//
// Sample to open a handle to OSRNTAPI device,
//  issue some requests and exit. 
//
// It is assumed that the driver portion
//  has been previously loaded (the easiest
//  way to load the driver is using a utility
//  such as OSR's Driver Loader, available
//  at OSR Online (http://www.osronline.com)
//
#include <windows.h>
#include <stdio.h>
#include <winioctl.h>
#include <osrntapi_ioctl.h>


_cdecl
main(ULONG argc, LPSTR *argv)
{
    HANDLE          deviceHandle;
    DWORD           code;
    UCHAR           readBuffer[4096];
    DWORD           bytesRead;
    char            deleteFile;

    //
    // Open the OSRNTAPI device
    //
    deviceHandle = CreateFile("\\\\.\\OSRNTAPI",  // Name of the NT "device" to open
                              GENERIC_READ|GENERIC_WRITE,  // Access rights requested
                              0,                           // Share access - NONE
                              0,                           // Security attributes - not used!
                              OPEN_EXISTING,               // Device must exist to open it.
                              0,                           // not used
                              0);                          // extended attributes - not used!
   

    //
    // If this call fails, check to figure out what the error is and report it.
    //
    if (deviceHandle == INVALID_HANDLE_VALUE) {

        code = GetLastError();

        printf("CreateFile failed with error 0x%x\n", code);

        return(code);
    }

    if (!DeviceIoControl(deviceHandle,
                         IOCTL_OSR_ENABLE_LOGGING,
                         0,          // Ptr to InBuffer
                         0,          // Length of InBuffer
                         0,          // Ptr to OutBuffer
                         0,          // Length of OutBuffer
                         &bytesRead, // BytesReturned
                         0))         // Ptr to Overlapped structure
    {
        
        code = GetLastError();
        
        printf("DeviceIoControl (reset) failed with error 0x%x\n", code);
        
        return;

    }

    //
    // Send a read
    //
    if (!ReadFile(deviceHandle,
                  readBuffer,
                  sizeof(readBuffer),
                  &bytesRead,
                  NULL)) {

        code = GetLastError();

        printf("ReadFile failed with error 0x%x\n", code);

        return;
    }

    //
    // Execute a work item
    //
    if (!DeviceIoControl(deviceHandle,
                         IOCTL_OSR_EXECUTE_WORK_ITEM,
                         0,          // Ptr to InBuffer
                         0,          // Length of InBuffer
                         0,          // Ptr to OutBuffer
                         0,          // Length of OutBuffer
                         &bytesRead, // BytesReturned
                         0))         // Ptr to Overlapped structure
    {
        
        code = GetLastError();
        
        printf("DeviceIoControl (reset) failed with error 0x%x\n", code);
        
        return;

    }

    if (!DeviceIoControl(deviceHandle,
                         IOCTL_OSR_DISABLE_LOGGING,
                         0,          // Ptr to InBuffer
                         0,          // Length of InBuffer
                         0,          // Ptr to OutBuffer
                         0,          // Length of OutBuffer
                         &bytesRead, // BytesReturned
                         0))         // Ptr to Overlapped structure
    {
        
        code = GetLastError();
        
        printf("DeviceIoControl (reset) failed with error 0x%x\n", code);
        
        return;

    }

    CloseHandle(deviceHandle);

    return;
}



