///////////////////////////////////////////////////////////////////////////////
//
//    (C) Copyright 1995 - 2003 OSR Open Systems Resources, Inc.
//    All Rights Reserved
//
//    This sofware is supplied for instructional purposes only.
//
//    OSR Open Systems Resources, Inc. (OSR) expressly disclaims any warranty
//    for this software.  THIS SOFTWARE IS PROVIDED  "AS IS" WITHOUT WARRANTY
//    OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT LIMITATION,
//    THE IMPLIED WARRANTIES OF MECHANTABILITY OR FITNESS FOR A PARTICULAR
//    PURPOSE.  THE ENTIRE RISK ARISING FROM THE USE OF THIS SOFTWARE REMAINS
//    WITH YOU.  OSR's entire liability and your exclusive remedy shall not
//    exceed the price paid for this material.  In no event shall OSR or its
//    suppliers be liable for any damages whatsoever (including, without
//    limitation, damages for loss of business profit, business interruption,
//    loss of business information, or any other pecuniary loss) arising out
//    of the use or inability to use this software, even if OSR has been
//    advised of the possibility of such damages.  Because some states/
//    jurisdictions do not allow the exclusion or limitation of liability for
//    consequential or incidental damages, the above limitation may not apply
//    to you.
//
//    OSR Open Systems Resources, Inc.
//    105 Route 101A Suite 19
//    Amherst, NH 03031  (603) 595-6500 FAX: (603) 595-6503
//    email bugs to: bugs@osr.com
//
//
//    MODULE:
//
//        OSRNTAPI.H
//
//    ABSTRACT:
//
//		This is the general include file for the OSRNTAPI sample driver.
//
//    AUTHOR(S):
//
//        OSR Open Systems Resources, Inc.
// 
//    REVISION:   
//
//
///////////////////////////////////////////////////////////////////////////////
#ifndef __OSR_NOTHING_H__
#define __OSR_NOTHING_H__ (1) // suppress duplicate loading of this file

#include <ntddk.h>

#include "osrntapi_ioctl.h"

//
// Defines
//
#define OSRNTAPI_DEVICENAME     L"\\Device\\OSRNTAPI"
#define OSRNTAPI_LINKNAME       L"\\DosDevices\\OSRNTAPI"

#define OSRNTAPI_LOGFILE        L"\\??\\C:\\osrntapi.log"

//
// Device Extension
//
// This is the per-device component of the device object.
//
typedef struct _OSR_DEVICE_EXT
{
	//
	// Device information
	//
	PDEVICE_OBJECT		DeviceObject;

    //
    // Is logging enabled?
    //
    BOOLEAN             LoggingEnabled;

    //
    // Log file handle
    //
    HANDLE              LogFileHandle;

    //
    // We'll need a work item
    //
    PIO_WORKITEM        WorkItem;

    //
    // An event to signal that the work item
    //  is finished
    //
    KEVENT              WorkItemEvent;

	//
	// Other cool stuff would normally go here
	//

} OSR_DEVICE_EXT, *POSR_DEVICE_EXT;



//
// Functions implemented in this driver
//
NTSTATUS DriverEntry(PDRIVER_OBJECT DriverObj, PUNICODE_STRING RegistryPath);
NTSTATUS OsrCreateClose(PDEVICE_OBJECT DeviceObject, PIRP Irp);
NTSTATUS OsrDeviceControl(PDEVICE_OBJECT DeviceObject, PIRP Irp);
NTSTATUS OsrRead(PDEVICE_OBJECT DeviceObject, PIRP Irp);
VOID     OsrWorkItem(PDEVICE_OBJECT DeviceObject, PVOID Context);
VOID     OsrUnload(PDRIVER_OBJECT DriverObject);


//
// External functions not exported
//  by ntddk.h
//
extern 
NTSTATUS 
  NtWriteFile(
    IN HANDLE  FileHandle,
    IN HANDLE  Event  OPTIONAL,
    IN PIO_APC_ROUTINE  ApcRoutine  OPTIONAL,
    IN PVOID  ApcContext  OPTIONAL,
    OUT PIO_STATUS_BLOCK  IoStatusBlock,
    IN PVOID  Buffer,
    IN ULONG  Length,
    IN PLARGE_INTEGER  ByteOffset  OPTIONAL,
    IN PULONG  Key  OPTIONAL
    );


#endif /* __OSR_NOTHING_H__ */
