//++
//  Native.c 
//
//  Demonstration of using native NT API for File I/O
//
//  Accompanies the article "Going Native",in the Summer
//  1996 (V3N3) issue of The NT Insider
//
//  ntinsider@osr.com - http://www.osr.com
//
//  THIS SOFTWARE IS SUPPLIED "AS IS", AND EXPLICITLY
//  WITHOUT WARRANTY OF ANY KIND. See accompanying
//  file "readme.txt" which contains the full text
//  outlining the conditions under which this material
//  is made available.
//
// 
//  Environment:
//
//    User mode, NT api.
//
//--
#include <stdlib.h>
#include <stdio.h>

//
// Start with NTDDK.H
//
#include <ntddk.h>

//
// Add the definitions for the native APIs we'll be using
//
#include "native.h"

//
// Here's to data to write to the file
//
PUCHAR Message = "Hello world! I was written using the native NT API.\n";

//
// MAIN
//
main (int Argc, char ** Argv )
    {
    NTSTATUS Status;
    UNICODE_STRING UnicodeFilespec;
    OBJECT_ATTRIBUTES ObjectAttributes;
    HANDLE FileHandle;
    IO_STATUS_BLOCK Iosb;
    ULONG MessageLength = strlen(Message);

    printf("Starting OSR's Native NT API Example...\n");

    //
    // Initialize a unicode string with the fully qualified path of the file
    // that we wish to create
    //
    RtlInitUnicodeString(&UnicodeFilespec, L"\\DosDevices\\C:\\Temp\\native.txt");


    //
    // Setup the name in an object attributes structure.
    // Note that we create a name that is case INsensitive
    //
    InitializeObjectAttributes(&ObjectAttributes,           // ptr to structure
                               &UnicodeFilespec,            // ptr to file spec
                               OBJ_CASE_INSENSITIVE,        // attributes
                               NULL,                        // root directory handle
                               NULL );                      // ptr to security descriptor

    //
    // Do the create.  In this particular case, we'll have the I/O Manager
    // make our write requests syncrhonous for our convenience.
    //
    Status = NtCreateFile(&FileHandle,                      // returned file handle
                          (GENERIC_WRITE | SYNCHRONIZE),    // desired access
                          &ObjectAttributes,                // ptr to object attributes
                          &Iosb,                            // ptr to I/O status block
                          0,                                // allocation size
                          FILE_ATTRIBUTE_NORMAL,            // file attributes
                          0,                                // share access
                          FILE_SUPERSEDE,                   // create disposition
                          FILE_SYNCHRONOUS_IO_NONALERT,     // create options
                          NULL,                             // ptr to extended attributes
                          0);                               // length of ea buffer

    //
    // Check the system service status
    //
    if( !NT_SUCCESS(Status) )
       	{
        printf("Create system service failed status = 0x%0x\n", Status);

        exit(0);
     	}


    //
    // Check the returned status too...
    //
    if(!NT_SUCCESS(Iosb.Status) )
        {
        printf("CREATE failed with status = 0x%0x\n",Iosb.Status);
        exit(0);
       }


    //
    // The file has been successfully created.  Let's try WRITING to it!
    // Note we don't use, or need, an event handle here since we've opened
    // the file for synchronous I/O.
    //
    Status = NtWriteFile(FileHandle,                   // file Handle
                         0,                            // event Handle
                         NULL,                         // APC entry point
                         NULL,                         // APC context
                         &Iosb,                        // IOSB address
                         Message,                      // ptr to data buffer
                         MessageLength,                // length
                         0,                            // byte offset
                         NULL);                        // key

    //
    // If the WRITE system service request fails, bail out...
    //
    if(!NT_SUCCESS(Status) )
        {
        printf("NtWriteFile request failed 0x%0x\n", Status);
        exit(0);
        }

    //
    // Check the returned status from the WRITE.  
    //
    if(!NT_SUCCESS(Iosb.Status) )
        {
        printf("WRITE failed with status = 0x%0x\n",Iosb.Status);
        exit(0);
       }

    //
    // Well, That's all folks!
    //
    Status = NtClose(FileHandle);


    //
    // If the CLOSE system service request fails, we're pretty hosed!
    //
    if(!NT_SUCCESS(Status) )
        {
        printf("NtClose request failed 0x%0x\n", Status);
        exit(0);
        }


    printf("OSR's Native NT API example complete!\n");

    exit(1);
    }
